#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//helical staircaseMod01.fsh   by   sympou
//https://www.shadertoy.com/view/7sSyzW
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// derived from :

// "Melange" by dr2 - 2022
// License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
// https://www.shadertoy.com/view/slKXD3

#define PI 3.1415926535

float sdHelixStairs( in vec3 p) {

    // parameters :
 
    float stairsNum = 2.;
    float slabNum = 40.; // number of slabs per rotation
    float rotDir = 1.; //1. or -1.

    float height = 10.;
    float axisWidth = 9.;
    float underSlab = .5;
    float slabWidth = 2.;
        
    float ang = height * atan (p.x, p.z) / PI * rotDir;
    float len = length(p.xz);
        
    vec2 h2 = height / vec2(slabNum*.5,stairsNum);

    p.xy = vec2(ang - p.y, ang + p.y)*0.5;
    p.xy = mod(p.xy, h2);

    p.x  = min(p.x, h2.x - p.x);
    p.y -= h2.y*0.5;
    
    float y1 = max( p.y - p.x, -(p.y + underSlab)*2. );
    float z1 = abs( len - axisWidth ) - slabWidth;
    
    //smoother sdf
    //if (y1>0. && z1>0.) { return length(vec2(y1,z1)); }
    
    return max(y1,z1);
    
}

float getVal ( in vec3 p ) {
    return sdHelixStairs(p);
}

float rayMarch( vec3 ro, vec3 rd) {

    float t = 0.;
    int i = 0;

    while ( i<100 && t<999. ) {
        float r = abs( getVal( ro + rd*t ) );
        if ( r <= 0.001*t ) break;
        t += r;
        i ++;
    }
    
    if (t>999.) { return -1.; }

    return t;
}

vec3 distance_field_normal(vec3 pos) {
    vec2 eps = vec2(0.0001,0.0);
    float nx = getVal(pos + eps.xyy);
    float ny = getVal(pos + eps.yxy);
    float nz = getVal(pos + eps.yyx);
    return normalize(vec3(nx, ny, nz)-getVal(pos));
}


//ambient occlusion
//https://www.shadertoy.com/view/MtlBWB
const vec3 sq = 1./vec3(sqrt(2.),sqrt(3.),sqrt(4.));
const float eps = 0.125;
const vec3 eps2 = eps*vec3(2.,3.,4.);
float ao(vec3 p, vec3 n) {
    
    float c1 = float(abs(n.x) < abs(n.y) && abs(n.x) < abs(n.z));
    float c2 = float(abs(n.y) < abs(n.z));
    float c3 = c2 - c2*c1;
    
    vec3 t = vec3(c1, c3, 1. - c1 - c3);
    vec3 u = cross(n, t);
    vec3 v = cross(n, u);    
    
    vec3 epn = eps2[2]*n + p;
    
    float occ  = max(getVal(p + eps*n),0.0);
          occ += max(getVal(p + eps*u),0.0);
          occ += max(getVal(p - eps*u),0.0);
          occ += max(getVal(p + eps*v),0.0);
          occ += max(getVal(p - eps*v),0.0);
    
    occ += (max(getVal(epn + eps2[2]*u),0.0)
        +   max(getVal(epn - eps2[2]*u),0.0)
        +   max(getVal(epn + eps2[2]*v),0.0)
        +   max(getVal(epn - eps2[2]*v),0.0))*0.5;

    occ += max(getVal(p + eps2[0]*n)*sq[0],0.0);
    occ += max(getVal(p + eps2[1]*n)*sq[1],0.0);
    occ += max(getVal(epn          )*sq[2],0.0);

    return max(1.0 - 1.0/(1.0+2.0*occ), 0.0);
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 p = (2.0*fragCoord.xy-iResolution.xy) / iResolution.y;
    vec2 m = iMouse.xy/iResolution.xy;
    if (m.x==0. && m.y==0.) { m = vec2(.5,.87); }

    //rotation of the object
    float time2 = iTime*0.125;
    mat3 rot = mat3(sin(time2),0., cos(time2),  0.,1.,0., cos(time2),0.,-sin(time2));

    //ray origin + direction
    vec3 ro = vec3(0., 0., 30. );
	vec3 rd = normalize( vec3(p,-2.0) );
    rd.yz *= mat2(cos(0.4),sin(0.4),-sin(0.4),cos(0.4));

    vec3 ro2 = ro*rot;
    vec3 rd2 = rd*rot;

    //output color
    vec3 col = vec3(0.0);
    
    
    //distance to the object
    float dist = rayMarch( ro2, rd2 );

    vec3 objPos;
    float tmin = 1e10;

    // if we touch the object :
    if (dist>0.0) {

        tmin = min(tmin,dist);
        vec3 hit = ro2 + rd2*dist;
        vec3 normals = distance_field_normal(hit);        
        objPos = ro2 + tmin*rd2;
        
        float diffuse = mix(normals.y,1.,0.65);
        float ao = ao(objPos, normals);

        col = vec3(0.8,0.8,1.)*diffuse*ao ;
    }
    
    //signed distance field viewer
    //inspired by tdhooper : https://www.shadertoy.com/view/MstcWs

    float offset = (m.y-0.5)*25.;
    if (tmin>9999. || (rot*objPos).z + offset < 0.) {
        
        vec3 planeHit = ro2 - rd2*(ro.z+offset)/rd.z;

        float sdf = getVal(planeHit);
        
        vec3 view = vec3(0.2,0.,1.)*mod(sdf, 0.5)/(1.+sdf*0.1);
        

        col = mix(col, view, m.x*0.75 );
    }
    

    fragColor = vec4( sqrt(col.rgb), 1.0 );
    
//////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

